<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Clinician extends Model 
{

    protected $table = 'clinicians';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'username', 'password', 'clinician_type', 'email', 'phone_number');
    protected $visible = array('name', 'username', 'clinician_type', 'email', 'phone_number');
    protected $hidden = array('password');

    public function discharges()
    {
        return $this->hasMany('App\Discharge');
    }

    public function prescriptions()
    {
        return $this->hasMany('App\Prescription');
    }

    public function surgeries()
    {
        return $this->hasMany('App\Surgery');
    }

    public function transfers()
    {
        return $this->hasMany('App\PatientTransfer');
    }

    public function deaths()
    {
        return $this->hasMany('App\Death');
    }

    public function transfusions()
    {
        return $this->hasMany('App\Transfusion');
    }

    public function opdEntries()
    {
        return $this->hasMany('App\OPDEntry');
    }

    public function fluids()
    {
        return $this->hasMany('App\Fluid');
    }

    public function vitals()
    {
        return $this->hasMany('App\Vital');
    }

}