<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Fluid extends Model 
{

    protected $table = 'fluids';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('patient_id', 'clinician_id', 'admission_id', 'date', 'time', 'intravenous', 'oral_fluid', 'output');
    protected $visible = array('patient_id', 'clinician_id', 'admission_id', 'date', 'time', 'intravenous', 'oral_fluid', 'output');

    public function patient()
    {
        return $this->belongsTo('App\Patient');
    }

    public function clinician()
    {
        return $this->belongsTo('App\Clinician');
    }

    public function admission()
    {
        return $this->belongsTo('App\Admission');
    }

}