<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class LabRequest extends Model 
{

    protected $table = 'lab_requests';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('lab_test_id', 'status');
    protected $visible = array('lab_test_id', 'status');

    public function labTest()
    {
        return $this->belongsTo('LabTest', 'id', 'lab_test_id');
    }

}