<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class OPDEntry extends Model 
{

    protected $table = 'opd_entries';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('clinician_id', 'patient_id', 'main_diagnosis_id', 'other_diagnosis', 'presenting_complaints', 'history_of_presenting_complaints');
    protected $visible = array('clinician_id', 'patient_id', 'main_diagnosis_id', 'other_diagnosis', 'presenting_complaints', 'history_of_presenting_complaints');

    public function patient()
    {
        return $this->belongsTo('App\Patient');
    }

    public function clinician()
    {
        return $this->belongsTo('App\Clinician');
    }

}