<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Surgery extends Model 
{

    protected $table = 'surgeries';
    public $timestamps = true;
    protected $fillable = array('patient_id', 'clinician_id', 'surgery_type_id', 'notes', 'status', 'date', 'start_time', 'end_time', 'pre_op_diagnosis', 'post_op_diagnosis');
    protected $visible = array('patient_id', 'clinician_id', 'surgery_type_id', 'notes', 'status', 'date', 'start_time', 'end_time', 'pre_op_diagnosis', 'post_op_diagnosis');

    public function surgeryDone()
    {
        return $this->hasOne('App\SurgeryType');
    }

}