<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class SurgeryType extends Model 
{

    protected $table = 'surgery_types';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'staus', 'price', 'cost_type');
    protected $visible = array('name', 'staus', 'price', 'cost_type');

    public function surgeries()
    {
        return $this->hasMany('App\Surgery');
    }

}