<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAdmissionsTable extends Migration {

	public function up()
	{
		Schema::create('admissions', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->bigInteger('patient_id')->unsigned();
			$table->bigInteger('clinician_id')->unsigned();
			$table->bigInteger('ward_id')->unsigned();
			$table->bigInteger('bed_id')->unsigned();
			$table->enum('status', array('discharged', 'dead', 'pending', 'admitted'));
		});
	}

	public function down()
	{
		Schema::drop('admissions');
	}
}