<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDischargesTable extends Migration {

	public function up()
	{
		Schema::create('discharges', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->bigInteger('patient_id')->unsigned();
			$table->enum('staus', array('partial', 'final'));
			$table->bigInteger('ward_id')->unsigned();
			$table->bigInteger('clinician_id')->unsigned();
			$table->string('outcome');
			$table->date('follow_up_date');
		});
	}

	public function down()
	{
		Schema::drop('discharges');
	}
}