<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFluidsTable extends Migration {

	public function up()
	{
		Schema::create('fluids', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->bigInteger('patient_id')->unsigned();
			$table->bigInteger('clinician_id')->unsigned();
			$table->bigInteger('admission_id')->unsigned();
			$table->date('date');
			$table->time('time');
			$table->smallInteger('intravenous')->unsigned();
			$table->smallInteger('oral_fluid')->unsigned();
			$table->smallInteger('output')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('fluids');
	}
}