<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateIpdEntriesTable extends Migration {

	public function up()
	{
		Schema::create('ipd_entries', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->bigInteger('clinician_id')->unsigned();
			$table->bigInteger('patient_id')->unsigned();
			$table->bigInteger('admission_id')->unsigned();
			$table->longText('treatment_notes')->unique();
		});
	}

	public function down()
	{
		Schema::drop('ipd_entries');
	}
}