<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOpdEntriesTable extends Migration {

	public function up()
	{
		Schema::create('opd_entries', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->bigInteger('clinician_id')->unsigned();
			$table->bigInteger('patient_id')->unsigned();
			$table->bigInteger('main_diagnosis_id')->unsigned();
			$table->string('other_diagnosis');
			$table->text('presenting_complaints');
			$table->mediumText('history_of_presenting_complaints')->unique();
		});
	}

	public function down()
	{
		Schema::drop('opd_entries');
	}
}