<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePatientDiagnosisTable extends Migration {

	public function up()
	{
		Schema::create('patient_diagnosis', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->bigInteger('patient_id')->unsigned();
			$table->bigInteger('clinician_id')->unsigned();
			$table->bigInteger('diagnoses_id')->unsigned();
			$table->enum('diagnosis_type', array('main', 'other'));
		});
	}

	public function down()
	{
		Schema::drop('patient_diagnosis');
	}
}