<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePatientsTable extends Migration {

	public function up()
	{
		Schema::create('patients', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name')->unique();
			$table->enum('gender', array('male', 'female', 'other'));
			$table->enum('patient_type', array('insured', 'cash'));
			$table->string('insurance_type')->nullable();
			$table->string('insurance_number')->unique();
			$table->date('date_of_birth');
			$table->enum('is_pregnant', array('yes', 'no'));
			$table->string('phone_number')->unique();
			$table->text('address');
			$table->string('contact_person');
			$table->string('contact_person_phone_number');
		});
	}

	public function down()
	{
		Schema::drop('patients');
	}
}