<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateWardsTable extends Migration {

	public function up()
	{
		Schema::create('wards', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->enum('gender_type', array('male', 'female', 'both'));
			$table->bigInteger('department_id')->unsigned();
			$table->string('name')->unique();
		});
	}

	public function down()
	{
		Schema::drop('wards');
	}
}