<?php

class CashCountTotal extends Eloquent {

	protected $table = 'cash_count_totals';
	public $timestamps = true;
	protected $fillable = array('cash_count_id', 'currency_id', 'total', 'conversion_rate');
	protected $visible = array('cash_count_id', 'total', 'conversion_rate');

	public function currency()
	{
		return $this->belongsTo('Currency', 'currency_id');
	}

	public function cashCount()
	{
		return $this->belongsTo('CashCount', 'cash_count_id');
	}

	public function money()
	{
		return $this->hasMany('CashCountMoney', 'cash_count_total_id');
	}

}