<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateVouchersTable extends Migration {

	public function up()
	{
		Schema::create('vouchers', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('reservation_id')->unsigned()->nullable();
			$table->string('voucher_code', 20)->nullable();
			$table->string('agent_name', 100)->nullable();
			$table->string('agent_phone', 20)->nullable();
			$table->string('hotel_name', 100)->nullable();
			$table->text('hotel_address')->nullable();
			$table->string('agency_name', 100)->nullable();
			$table->string('agency_rnc', 50)->nullable();
			$table->string('agency_phone', 20)->nullable();
			$table->text('agency_address')->nullable();
			$table->string('route_name', 100)->nullable();
			$table->text('route_address')->nullable();
			$table->text('route_collection_location')->nullable();
			$table->time('route_collection_time')->nullable();
			$table->decimal('grand_total', 10,4)->nullable();
			$table->string('status', 50)->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('vouchers');
	}
}