<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCommentsTable extends Migration {

	public function up()
	{
		Schema::create('comments', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name', 20);
			$table->timestamp('date');
			$table->text('text');
			$table->integer('status')->default('0');
			$table->integer('rating');
			$table->integer('quest')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('comments');
	}
}