<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateQuestsTable extends Migration {

	public function up()
	{
		Schema::create('quests', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('city')->unsigned();
			$table->softDeletes();
			$table->timestamps();
			$table->string('name', 40);
			$table->string('number', 20);
			$table->string('picture', 200);
			$table->string('icon', 100);
			$table->text('text');
			$table->integer('duration');
			$table->integer('pause');
		});
	}

	public function down()
	{
		Schema::drop('quests');
	}
}