<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateReservationsTable extends Migration {

	public function up()
	{
		Schema::create('reservations', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('lastName', 50);
			$table->string('firstName', 50);
			$table->string('email', 50);
			$table->string('phone', 15);
			$table->integer('emailStatus');
			$table->integer('phoneStatus');
			$table->text('comment');
			$table->integer('paymentStatus');
			$table->integer('adminStatus');
			$table->integer('day')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('reservations');
	}
}