<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAssetsTable extends Migration {

	public function up()
	{
		Schema::create('assets', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('manufacturer_id');
			$table->integer('dealer_id');
			$table->integer('service_provider_id');
			$table->integer('asset_type_id');
			$table->tinyInteger('status');
			$table->string('sn')->unique();
			$table->string('ip');
			$table->string('software_version');
			$table->string('firmware_version');
			$table->timestamp('purchased_at')->nullable();
			$table->timestamp('installed_at')->nullable();
			$table->string('warrant_due_at');
			$table->timestamp('last_fixed_at')->nullable();
			$table->timestamp('metric_updated_at')->nullable();
			$table->string('dynamic_attributes_doc_id');
			$table->boolean('poweron');
			$table->enum('available_status', array('0', '1', '2'));
			$table->integer('location_id')->unsigned();
			$table->integer('asset_model_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('assets');
	}
}