<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('company_id')->references('id')->on('companies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('department_id')->references('id')->on('departments')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('companies', function(Blueprint $table) {
			$table->foreign('contact_id')->references('id')->on('contacts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('companies', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('cinemas', function(Blueprint $table) {
			$table->foreign('region_id')->references('id')->on('region')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('locations', function(Blueprint $table) {
			$table->foreign('cinema_id')->references('id')->on('cinemas')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('assets', function(Blueprint $table) {
			$table->foreign('location_id')->references('id')->on('locations')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('assets', function(Blueprint $table) {
			$table->foreign('asset_model_id')->references('id')->on('asset_models')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('events', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('event_categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('events', function(Blueprint $table) {
			$table->foreign('location_id')->references('id')->on('locations')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('events', function(Blueprint $table) {
			$table->foreign('ticket_id')->references('id')->on('tickets')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('events', function(Blueprint $table) {
			$table->foreign('event_handler_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('gateways', function(Blueprint $table) {
			$table->foreign('cinema_id')->references('id')->on('cinemas')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('component_attributes', function(Blueprint $table) {
			$table->foreign('component_id')->references('id')->on('components')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('asset_brands', function(Blueprint $table) {
			$table->foreign('manufacturer_id')->references('id')->on('companies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('asset_models', function(Blueprint $table) {
			$table->foreign('asset_brand_id')->references('id')->on('asset_brands')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('contacts', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('ticket_flows', function(Blueprint $table) {
			$table->foreign('ticket_id')->references('id')->on('tickets')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('ticket_flows', function(Blueprint $table) {
			$table->foreign('owner_Id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('ticket_flows', function(Blueprint $table) {
			$table->foreign('assignee_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('medias', function(Blueprint $table) {
			$table->foreign('event_id')->references('id')->on('events')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('medias', function(Blueprint $table) {
			$table->foreign('asset_id')->references('id')->on('assets')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('medias', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('asset_event', function(Blueprint $table) {
			$table->foreign('event_id')->references('id')->on('events')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('asset_event', function(Blueprint $table) {
			$table->foreign('asset_id')->references('id')->on('assets')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('asset_fix', function(Blueprint $table) {
			$table->foreign('component_id')->references('id')->on('components')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('asset_transfer', function(Blueprint $table) {
			$table->foreign('previous_location_id')->references('id')->on('locations')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('asset_transfer', function(Blueprint $table) {
			$table->foreign('previous_cinema_id')->references('id')->on('cinemas')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('asset_transfer', function(Blueprint $table) {
			$table->foreign('current_location_id')->references('id')->on('locations')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('asset_transfer', function(Blueprint $table) {
			$table->foreign('current_cinema_id')->references('id')->on('cinemas')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('malfunctions', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('ticket_logs', function(Blueprint $table) {
			$table->foreign('ticket_id')->references('id')->on('tickets')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('ticket_logs', function(Blueprint $table) {
			$table->foreign('sender_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('ticket_logs', function(Blueprint $table) {
			$table->foreign('receiver_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_company_id_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_role_id_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_department_id_foreign');
		});
		Schema::table('companies', function(Blueprint $table) {
			$table->dropForeign('companies_contact_id_foreign');
		});
		Schema::table('companies', function(Blueprint $table) {
			$table->dropForeign('companies_user_id_foreign');
		});
		Schema::table('cinemas', function(Blueprint $table) {
			$table->dropForeign('cinemas_region_id_foreign');
		});
		Schema::table('locations', function(Blueprint $table) {
			$table->dropForeign('locations_cinema_id_foreign');
		});
		Schema::table('assets', function(Blueprint $table) {
			$table->dropForeign('assets_location_id_foreign');
		});
		Schema::table('assets', function(Blueprint $table) {
			$table->dropForeign('assets_asset_model_id_foreign');
		});
		Schema::table('events', function(Blueprint $table) {
			$table->dropForeign('events_category_id_foreign');
		});
		Schema::table('events', function(Blueprint $table) {
			$table->dropForeign('events_location_id_foreign');
		});
		Schema::table('events', function(Blueprint $table) {
			$table->dropForeign('events_ticket_id_foreign');
		});
		Schema::table('events', function(Blueprint $table) {
			$table->dropForeign('events_event_handler_id_foreign');
		});
		Schema::table('gateways', function(Blueprint $table) {
			$table->dropForeign('gateways_cinema_id_foreign');
		});
		Schema::table('component_attributes', function(Blueprint $table) {
			$table->dropForeign('component_attributes_component_id_foreign');
		});
		Schema::table('asset_brands', function(Blueprint $table) {
			$table->dropForeign('asset_brands_manufacturer_id_foreign');
		});
		Schema::table('asset_models', function(Blueprint $table) {
			$table->dropForeign('asset_models_asset_brand_id_foreign');
		});
		Schema::table('contacts', function(Blueprint $table) {
			$table->dropForeign('contacts_user_id_foreign');
		});
		Schema::table('ticket_flows', function(Blueprint $table) {
			$table->dropForeign('ticket_flows_ticket_id_foreign');
		});
		Schema::table('ticket_flows', function(Blueprint $table) {
			$table->dropForeign('ticket_flows_owner_Id_foreign');
		});
		Schema::table('ticket_flows', function(Blueprint $table) {
			$table->dropForeign('ticket_flows_assignee_id_foreign');
		});
		Schema::table('medias', function(Blueprint $table) {
			$table->dropForeign('medias_event_id_foreign');
		});
		Schema::table('medias', function(Blueprint $table) {
			$table->dropForeign('medias_asset_id_foreign');
		});
		Schema::table('medias', function(Blueprint $table) {
			$table->dropForeign('medias_user_id_foreign');
		});
		Schema::table('asset_event', function(Blueprint $table) {
			$table->dropForeign('asset_event_event_id_foreign');
		});
		Schema::table('asset_event', function(Blueprint $table) {
			$table->dropForeign('asset_event_asset_id_foreign');
		});
		Schema::table('asset_fix', function(Blueprint $table) {
			$table->dropForeign('asset_fix_component_id_foreign');
		});
		Schema::table('asset_transfer', function(Blueprint $table) {
			$table->dropForeign('asset_transfer_previous_location_id_foreign');
		});
		Schema::table('asset_transfer', function(Blueprint $table) {
			$table->dropForeign('asset_transfer_previous_cinema_id_foreign');
		});
		Schema::table('asset_transfer', function(Blueprint $table) {
			$table->dropForeign('asset_transfer_current_location_id_foreign');
		});
		Schema::table('asset_transfer', function(Blueprint $table) {
			$table->dropForeign('asset_transfer_current_cinema_id_foreign');
		});
		Schema::table('malfunctions', function(Blueprint $table) {
			$table->dropForeign('malfunctions_user_id_foreign');
		});
		Schema::table('ticket_logs', function(Blueprint $table) {
			$table->dropForeign('ticket_logs_ticket_id_foreign');
		});
		Schema::table('ticket_logs', function(Blueprint $table) {
			$table->dropForeign('ticket_logs_sender_id_foreign');
		});
		Schema::table('ticket_logs', function(Blueprint $table) {
			$table->dropForeign('ticket_logs_receiver_id_foreign');
		});
	}
}