<?php

namespace App\Models;

class Asset extends Eloquent {

	protected $table = 'assets';
	public $timestamps = true;

	public function serviceProvider()
	{
		return $this->belongsTo('Company', 'service_provider_id');
	}

	public function dealer()
	{
		return $this->belongsTo('Company', 'dealer_id');
	}

	public function manufacturer()
	{
		return $this->belongsTo('Company', 'manufacturer_id');
	}

	public function assetType()
	{
		return $this->belongsTo('AssetType');
	}

	public function model()
	{
		return $this->belongsTo('AssetModel');
	}

}