<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAddressTable extends Migration {

	public function up()
	{
		Schema::create('address', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->string('first_name');
			$table->string('last_name');
			$table->string('city');
			$table->string('street');
			$table->integer('building_number');
			$table->integer('apartment_number');
			$table->string('phone');
			$table->enum('type', array('home', 'work'));
			$table->string('description');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('address');
	}
}