<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('products', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('vendor_id')->unsigned();
			$table->string('name');
			$table->integer('category_id')->unsigned();
			$table->integer('maxmim_stock_for_client')->default('0');
			$table->float('weight');
			$table->string('sku');
			$table->string('description');
			$table->integer('stock');
			$table->float('regluar_price');
			$table->enum('is_sale', array('true', 'false'));
			$table->float('sale_precent');
			$table->date('sale_expire_date');
			$table->string('catching_word');
			$table->string('code');
			$table->enum('status', array('active', 'deactivate'));
			$table->timestamps();
			$table->string('brand');
		});
	}

	public function down()
	{
		Schema::drop('products');
	}
}