<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->string('order_number');
			$table->float('total_price');
			$table->integer('address_id');
			$table->enum('status', array('done', 'preparing', 'canceled'));
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}