<?php

namespace models;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;
	protected $fillable = array('full_name', 'email', 'password', 'fb_id', 'gmail_id', 'twiiter_id', 'role', 'phone', 'email_code');

	public function Vendor()
	{
		return $this->hasOne('models\Vendor');
	}

	public function Orders()
	{
		return $this->hasMany('models\Order');
	}

	public function address()
	{
		return $this->hasMany('models\Adress');
	}

	public function Credit()
	{
		return $this->hasMany('models\Credit');
	}

	public function Products()
	{
		return $this->belongsToMany('models\UserProduct');
	}

}