<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('full_name');
			$table->string('email')->unique();
			$table->string('password');
			$table->string('fb_id');
			$table->string('gmail_id');
			$table->string('twiiter_id');
			$table->enum('role', array('client', 'seller', 'admin'));
			$table->string('phone');
			$table->enum('email_verified', array('true', 'false'));
			$table->string('email_code');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}