<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAccountsTable extends Migration {

	public function up()
	{
		Schema::create('accounts', function(Blueprint $table) {
			$table->enum('platform', array(''twitter'', ''instagram'', ''facebook''));
			$table->string('user_name', 255);
			$table->string('user_email', 100);
			$table->increments('id');
			$table->string('user_phone', 100);
			$table->integer('user_id');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('accounts');
	}
}