<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOffersTable extends Migration {

	public function up()
	{
		Schema::create('offers', function(Blueprint $table) {
			$table->increments('id');
			$table->date('start_at')->nullable();
			$table->date('end_date')->nullable();
			$table->string('discount')->nullable();
			$table->integer('product_id')->unsigned();
			$table->integer('category_id')->unsigned();
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('offers');
	}
}