<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Order extends Eloquent {

	protected $table = 'orders';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function user()
	{
		return $this->belongsTo('App\Models\User', 'user_id');
	}

	public function capon()
	{
		return $this->belongsTo('App\Models\Coupon', 'capon_id');
	}

	public function address()
	{
		return $this->belongsTo('App\Models\Address', 'address_id');
	}

	public function products()
	{
		return $this->belongsToMany('App\Models\Product');
	}

}