<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function ratings()
	{
		return $this->hasMany('App\Models\Rating');
	}

	public function comments()
	{
		return $this->hasMany('App\Models\Comment');
	}

	public function notifications()
	{
		return $this->hasMany('App\Models\Notification');
	}

	public function addresses()
	{
		return $this->hasMany('App\Models\Address');
	}

	public function merchants()
	{
		return $this->belongsToMany('App\Models\Merchant');
	}

	public function products()
	{
		return $this->belongsToMany('App\Models\Product');
	}

}