<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Order extends Model 
{

    protected $table = 'order';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('date', 'country_id', 'mall_id', 'user_id', 'service_id', 'car_number', 'payment_method', 'discount_percent', 'total', 'status', 'park_id', 'client_name', 'client_phone', 'is_client');

    public function service()
    {
        return $this->belongsTo('Service', 'service_id');
    }

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function mall()
    {
        return $this->belongsTo('Mall', 'mall_id');
    }

    public function country()
    {
        return $this->belongsTo('Country', 'country_id');
    }

    public function park()
    {
        return $this->belongsTo('Park', 'park_id');
    }

    public function client()
    {
        return $this->belongsTo('User', 'client_id');
    }

    public function order_covers()
    {
        return $this->hasMany('OrderCover', 'order_id');
    }

}