<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Service extends Model 
{

    protected $table = 'service';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('country_id', 'car_id', 'service_type_id', 'price');

    public function country()
    {
        return $this->belongsTo('Country', 'country_id');
    }

    public function car()
    {
        return $this->belongsTo('Car', 'car_id');
    }

    public function service_type()
    {
        return $this->belongsTo('ServiceType', 'service_type_id');
    }

    public function service_covers()
    {
        return $this->hasMany('ServiceCover', 'service_id');
    }

}