<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class SupplyCountry extends Model 
{

    protected $table = 'supply_country';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('country_id', 'supply_id');

    public function country()
    {
        return $this->belongsTo('Country', 'country_id');
    }

    public function supply()
    {
        return $this->belongsTo('Supply', 'supply_id');
    }

}