<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Category extends Eloquent {

	protected $table = 'category';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name_en', 'name_ar');

	public function countries()
	{
		return $this->belongsToMany('Country', 'category_country', 'category_id', 'country_id');
	}

}