<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class DamageRequest extends Eloquent {

	protected $table = 'damage_request';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('mall_id', 'supply_id', 'quantity', 'user_id');

	public function supply()
	{
		return $this->belongsTo('Supply', 'supply_id');
	}

	public function mall()
	{
		return $this->belongsTo('Mall', 'mall_id');
	}

	public function user()
	{
		return $this->belongsTo('User', 'user_id');
	}

}