<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Expense extends Eloquent {

	protected $table = 'expense';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('country_id', 'mall_id', 'user_id', 'amount', 'date', 'type', 'group', 'from', 'description', 'description_ar');

	public function country()
	{
		return $this->belongsTo('Country', 'country_id');
	}

	public function mall()
	{
		return $this->belongsTo('Mall', 'mall_id');
	}

	public function user()
	{
		return $this->belongsTo('User', 'user_id');
	}

}