<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Option extends Eloquent {

	protected $table = 'option';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('option_category_id', 'name_en', 'name_ar', 'description_en', 'description_ar');

	public function option_category()
	{
		return $this->belongsTo('OptionCategory', 'option_category_id');
	}

}