<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class OrderOption extends Eloquent {

	protected $table = 'order_option';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('order_product_id', 'option_id', 'price');

	public function product()
	{
		return $this->belongsTo('OrderProduct', 'order_product_id');
	}

	public function option()
	{
		return $this->belongsTo('Option', 'option_id');
	}

}