<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Product extends Eloquent {

	protected $table = 'product';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name_en', 'name_ar', 'price', 'category_id', 'country_id', 'description_en', 'description_ar', 'code');

	public function country()
	{
		return $this->belongsTo('Country', 'country_id');
	}

	public function category()
	{
		return $this->belongsTo('Category', 'category_id');
	}

	public function options()
	{
		return $this->hasMany('ProductOption', 'product_id');
	}

}