<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class RequestItem extends Eloquent {

	protected $table = 'request_item';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('request_id', 'supply_id', 'quantity');

	public function request()
	{
		return $this->belongsTo('Request', 'request_id');
	}

	public function supply()
	{
		return $this->belongsTo('Supply', 'supply_id');
	}

}