<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class ServiceCover extends Eloquent {

	protected $table = 'service_cover';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('service_id', 'cover_id', 'quantity');

	public function service()
	{
		return $this->belongsTo('Service', 'service_id');
	}

	public function cover()
	{
		return $this->belongsTo('Cover', 'cover_id');
	}

}