<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Stock extends Eloquent {

	protected $table = 'stock';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('supply_id', 'quantity', 'damaged', 'user_id', 'country_id');

	public function supply()
	{
		return $this->belongsTo('Supply', 'supply_id');
	}

	public function user()
	{
		return $this->belongsTo('User', 'user_id');
	}

	public function country()
	{
		return $this->belongsTo('Country', 'country_id');
	}

}