<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class UserMeta extends Eloquent {

	protected $table = 'user_meta';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('country_id', 'mall_id', 'player_id', 'user_id');

	public function country()
	{
		return $this->belongsTo('Country', 'country_id');
	}

	public function mall()
	{
		return $this->belongsTo('Mall', 'mall_id');
	}

	public function user()
	{
		return $this->belongsTo('User', 'user_id');
	}

}