<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Area extends Model 
{

    protected $table = 'area';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('area', 'country_id');

    public function malls()
    {
        return $this->hasMany('Mall', 'area_id');
    }

    public function country()
    {
        return $this->belongsTo('Country', 'country_id');
    }

}