<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Car extends Model 
{

    protected $table = 'car';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name_en', 'name_ar');

    public function countries()
    {
        return $this->belongsToMany('Country', 'car_country', 'car_id', 'country_id');
    }

}