<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class CarCountry extends Model 
{

    protected $table = 'car_country';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('car_id', 'country_id');

    public function car()
    {
        return $this->belongsTo('Car', 'car_id');
    }

    public function country()
    {
        return $this->belongsTo('Country', 'country_id');
    }

}