<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class DamageRequest extends Model 
{

    protected $table = 'damage_request';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('mall_id', 'supply_id', 'quantity', 'user_id');

    public function supply()
    {
        return $this->belongsTo('Supply', 'supply_id');
    }

    public function mall()
    {
        return $this->belongsTo('Mall', 'mall_id');
    }

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

}