<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class RevenueReport extends Model 
{

    protected $table = 'revenue_report';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('date', 'country_id', 'mall_id', 'jeep', 'vip', 'vvip', 'subscription', 'total_wash', 'total_money', 'expenses', 'net_sale', 'p_seat', 'p_gear', 'p_steering', 'p_mat', 'bag', 'seat', 'gear', 'steering');

    public function mall()
    {
        return $this->belongsTo('Mall', 'mall_id');
    }

    public function country()
    {
        return $this->belongsTo('Country', 'country_id');
    }

}