<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ServiceCover extends Model 
{

    protected $table = 'service_cover';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('service_id', 'cover_id', 'quantity');

    public function service()
    {
        return $this->belongsTo('Service', 'service_id');
    }

    public function cover()
    {
        return $this->belongsTo('Cover', 'cover_id');
    }

}